using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class KingsTalisman : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public KingsTalisman() : base( 0x2F59 )
		{
			Hue = 1150;
			Protection = new TalismanAttribute( typeof( DrakAuberon ), 25, "Drak Auberon" );
			Blessed = true;
			MaxChargeTime = 1800;
			MaxCharges = 40;
			Charges = 40;
			Summoner = new TalismanAttribute( typeof( Ribs ), 2, 1022546 );
			Name = "Kralovsky amulet";
		}
		
		public KingsTalisman( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
